package com.moneyhash.shared
import platform.UIKit.UIDevice

// Note: no need to define CommonParcelize here (bc its @OptionalExpectation)
actual interface CommonParcelable // not used on iOS
// Note: no need to define CommonTypeParceler<T,P : CommonParceler<in T>> here bc its an @OptionalExpectation
actual interface CommonParceler<T> // not used on iOS

class IOSPlatform: Platform {
    override val name: String = UIDevice.currentDevice.systemName() + " " + UIDevice.currentDevice.systemVersion
    override val deviceInfo: String = "iOS Device Info, Model: ${UIDevice.currentDevice.model}, Name: ${UIDevice.currentDevice.name}, System Name: ${UIDevice.currentDevice.systemName}, System Version: ${UIDevice.currentDevice.systemVersion}"
}

actual fun getPlatform(): Platform = IOSPlatform()