package com.moneyhash.shared.datasource.network

import com.moneyhash.shared.localization.LocalizationManager
import com.moneyhash.shared.util.extensions.JsonWithIgnoredUnknownKeys
import io.ktor.client.*
import io.ktor.client.engine.darwin.*
import io.ktor.client.plugins.*
import io.ktor.client.plugins.contentnegotiation.*
import io.ktor.client.plugins.logging.*
import io.ktor.client.statement.*
import io.ktor.http.*
import io.ktor.serialization.kotlinx.*

actual class KtorClientFactory {
    actual fun build(enableLogs: Boolean, sdkVersion: String): HttpClient {
        return HttpClient(Darwin) {
            expectSuccess = true
            if (enableLogs) {
                install(Logging) {
                    level = LogLevel.ALL
                }
            }

            install(UserAgent) {
                agent = "Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.0 Mobile/15E148 Safari/604.1"
            }

            install(DefaultRequest) {
                handleSdkVersionHeaderHeader("ios@$sdkVersion")
            }

            install(ContentNegotiation) {
                register(
                    ContentType.Application.Json,
                    KotlinxSerializationConverter(JsonWithIgnoredUnknownKeys)
                )
            }

            HttpResponseValidator {

                validateResponse { response: HttpResponse ->
                    this.handleResponseValidation(response)
                }

                handleResponseExceptionWithRequest { cause, _ ->
                    cause.handleNetworkException()
                }
            }
        }
    }
}