package com.moneyhash.shared.datasource.network.base

import com.moneyhash.shared.datasource.network.requestbuilder.RequestBuilder
import com.moneyhash.shared.util.extensions.JsonWithIgnoredUnknownKeys
import io.ktor.client.*
import io.ktor.client.call.*
import io.ktor.client.request.*
import kotlinx.serialization.json.JsonElement

class BaseService(
    val httpClient: HttpClient,
    baseUrl: String
) : KmmBaseService(baseUrl) {

    @Throws(Throwable::class)
    suspend inline fun <reified T> get(
        crossinline requestBuilder: RequestBuilder.() -> Unit = {},
    ): T {
        val builder = RequestBuilder()
        builder.requestBuilder()
        val json = httpClient.get(buildRequest(builder)).body<JsonElement>()
        return json.convert()
    }

    suspend inline fun <reified T> post(
        crossinline requestBuilder: RequestBuilder.() -> Unit = {},
    ): T {
        val builder = RequestBuilder()
        builder.requestBuilder()
        val json = httpClient.post(buildRequest(builder)).body<JsonElement>()
        return if (T::class.simpleName == Unit::class.simpleName) {
            Unit as T
        } else {
            json.convert()
        }
    }

    suspend inline fun <reified T> patch(
        crossinline requestBuilder: RequestBuilder.() -> Unit = {},
    ): T {
        val builder = RequestBuilder()
        builder.requestBuilder()
        val json = httpClient.patch(buildRequest(builder)).body<JsonElement>()
        return if (T::class.simpleName == Unit::class.simpleName) {
            Unit as T
        } else {
            json.convert()
        }
    }

    suspend inline fun <reified T> put(crossinline requestBuilder: RequestBuilder.() -> Unit = {},): T {
        val builder = RequestBuilder()
        builder.requestBuilder()
        val json =
            httpClient.put(buildRequest(builder)).body<JsonElement>()
        return if (T::class.simpleName == Unit::class.simpleName) {
            Unit as T
        } else {
            json.convert()
        }
    }

    suspend inline fun <reified T> delete(
        crossinline requestBuilder: RequestBuilder.() -> Unit = {},
    ): T {
        val builder = RequestBuilder()
        builder.requestBuilder()
        val json =
            httpClient.delete(buildRequest(builder)).body<JsonElement>()
        return if (T::class.simpleName == Unit::class.simpleName) {
            Unit as T
        } else {
            json.convert()
        }
    }
}

inline fun <reified T> JsonElement.convert(): T {
    return JsonWithIgnoredUnknownKeys.decodeFromString(this.toString())
}