package com.moneyhash.shared.datasource.network.base

import com.moneyhash.shared.datasource.network.requestbuilder.RequestBuilder
import com.moneyhash.shared.datasource.network.requestbuilder.RequestContent
import com.moneyhash.shared.localization.LocalizationManager
import io.ktor.client.request.*

open class KmmBaseService(private val baseUrl: String) {
    fun buildRequest(
        requestBuilder: RequestBuilder
    ): HttpRequestBuilder {
        val builderData = requestBuilder.build()
        val urlSuffix = builderData.first
        val headers = builderData.second.filterIsInstance<RequestContent.Header>()
        val queries = builderData.second.filterIsInstance<RequestContent.Query>()
        val body = builderData.second.filterIsInstance<RequestContent.Body<*>>()
        val builder = HttpRequestBuilder().apply {
            url(baseUrl + urlSuffix)

            queries.forEach { param ->
                parameter(param.key, param.value)
            }

            headers.forEach {
                header(it.key, it.value)
            }

            if (body.isNotEmpty()) {
                this.setBody(body.first().value!!)
            }

            parameter("lang", LocalizationManager.locale.name.lowercase())
        }
        return builder
    }
}