package com.moneyhash.shared.datasource.network.model

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class BrandSettingsData(
    @SerialName("brand_primary_color")
    val brandPrimaryColor: String? = null,
    @SerialName("brand_accent_color")
    val brandAccentColor: String? = null,
    @SerialName("icon")
    val icon: String? = null,
    @SerialName("privacy_policy")
    val privacyPolicy: String? = null,
    @SerialName("terms_of_service")
    val termsOfService: String? = null,
): CommonParcelable

@Serializable
@CommonParcelize
data class BrandSettingsModel(
    @SerialName("brand_primary_color")
    val brandPrimaryColor: String? = null,

    @SerialName("brand_accent_color")
    val brandAccentColor: String? = null,

    @SerialName("icon")
    val icon: String? = null,

    @SerialName("privacy_policy")
    val privacyPolicy: String? = null,

    @SerialName("terms_of_service")
    val termsOfService: String? = null,

    @SerialName("hide_header")
    val hideHeader: Boolean? = null,

    @SerialName("hide_amount_sidebar")
    val hideAmountSidebar: Boolean? = null,
) : CommonParcelable

fun BrandSettingsData.toModel(hideHeader: Boolean?, hideAmountSidebar: Boolean?) =
    BrandSettingsModel(
        brandPrimaryColor,
        brandAccentColor,
        icon,
        privacyPolicy,
        termsOfService,
        hideHeader,
        hideAmountSidebar
    )