package com.moneyhash.shared.datasource.network.model.auth

import com.moneyhash.shared.datasource.network.model.payment.Status
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class AuthResponse(
    @SerialName("data")
    val data: AuthData? = null,
    @SerialName("status")
    val status: Status? = null
)

@Serializable
data class AuthData(
    @SerialName("user")
    val user: User? = null,
    @SerialName("token")
    val token: AuthToken? = null
)

@Serializable
data class AuthToken(
    @SerialName("access")
    val access: String? = null,
    @SerialName("refresh")
    val refresh: String? = null
)

@Serializable
data class User(
    @SerialName("is_superuser")
    val isSuperuser: Boolean? = null,
    @SerialName("name")
    val name: String? = null,
    @SerialName("id")
    val id: Int? = null,
    @SerialName("email")
    val email: String? = null,
    @SerialName("is_org_admin")
    val isOrgAdmin: Boolean? = null
)