package com.moneyhash.shared.datasource.network.model.card

import com.moneyhash.shared.datasource.network.model.BrandSettingsData
import com.moneyhash.shared.datasource.network.model.Redirect
import com.moneyhash.shared.datasource.network.model.common.IntentState
import com.moneyhash.shared.datasource.network.model.payment.IntentStateDetails
import com.moneyhash.shared.datasource.network.model.payment.PaymentInformation
import com.moneyhash.shared.datasource.network.model.payment.RenderStrategy
import com.moneyhash.shared.datasource.network.model.payment.Status
import com.moneyhash.shared.datasource.network.model.payment.getBillingFields
import com.moneyhash.shared.datasource.network.model.payment.getIntentStateDetails
import com.moneyhash.shared.datasource.network.model.payment.getRedirectStrategy
import com.moneyhash.shared.datasource.network.model.payment.getShippingFields
import com.moneyhash.shared.datasource.network.model.payment.methods.IntentMethods
import com.moneyhash.shared.datasource.network.model.payment.methods.PaymentMethod
import com.moneyhash.shared.datasource.network.model.payment.methods.toPaymentMethods
import com.moneyhash.shared.datasource.network.model.payment.toNativePayData
import com.moneyhash.shared.domain.model.CardState
import com.moneyhash.shared.domain.model.PaymentActions
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class CardDetails(
    @SerialName("data")
    val data: CardData? = null,
    @SerialName("status")
    val status: Status? = null
)

@Serializable
data class CardData(
    @SerialName("next_action")
    val nextAction: String? = null,
    @SerialName("intent_sdk_state")
    val intentSdkState: IntentState? = null,
    @SerialName("action_data")
    val actionData: CardActionData? = null,
    @SerialName("card_intent")
    val cardIntent: CardIntent? = null,
    @SerialName("brand_settings")
    val brandSettings: BrandSettingsData? = null,
)

fun CardData.getIntentStateDetails(): IntentStateDetails? {
    when(this.intentSdkState) {

        IntentState.URL_TO_RENDER -> {
            var url = this.actionData?.redirect?.redirectUrl
            if (url == null) {
                url = this.actionData?.iframeUrl
            }
            return  IntentStateDetails.UrlToRender(url = url, renderStrategy = this.getRedirectStrategy())
        }
        IntentState.SUCCESS -> {
            return IntentStateDetails.Success
        }
        IntentState.FAILED -> {
            return IntentStateDetails.Failed
        }
        else -> return null
    }
}

fun CardData.getRedirectStrategy(): RenderStrategy {
    return when (nextAction) {
        PaymentActions.REDIRECT -> {
            return RenderStrategy.REDIRECT
        }
        PaymentActions.POPUP_IFRAME -> {
            return RenderStrategy.POPUP_IFRAME
        }
        PaymentActions.IFRAME -> {
            return  RenderStrategy.IFRAME
        }

        else -> {
            RenderStrategy.NONE
        }
    }
}

@Serializable
data class CardIntent(
    @SerialName("id")
    val id: String? = null,
    @SerialName("hide_amount_sidebar")
    val hideAmountSidebar: Boolean? = null,
    @SerialName("hide_header")
    val hideHeader: Boolean? = null,
)

@Serializable
data class CardActionData(
    @SerialName("status")
    val status: String? = null,
    @SerialName("redirect")
    val redirect: Redirect? = null,
    @SerialName("iframe_url")
    val iframeUrl: String? = null
)

fun CardDetails.toCardState(): CardState {
    return when (data?.actionData?.status) {
        PaymentActions.SUCCESSFUL -> {
            CardState.Success(toCardIntentResult())
        }
        PaymentActions.FAILED, PaymentActions.INLINE_FAILED -> {
            CardState.Failed(toCardIntentResult())
        }
        else -> {
            CardState.Unknown
        }
    }
}
fun CardDetails.getIntentStateDetails(): IntentStateDetails? {
    return data?.getIntentStateDetails()
}
