package com.moneyhash.shared.datasource.network.model.card

import com.moneyhash.shared.datasource.network.model.BrandSettingsModel
import com.moneyhash.shared.datasource.network.model.toModel
import kotlinx.serialization.Serializable

@Serializable
class CardIntentResult(
    val id: String? = null,
    val status: String? = null,
    val brandSettings: BrandSettingsModel? = null,
)

fun CardDetails.toCardIntentResult() = CardIntentResult(
    data?.cardIntent?.id,
    data?.actionData?.status,
    data?.brandSettings?.toModel(data.cardIntent?.hideHeader, data.cardIntent?.hideAmountSidebar)
)
