package com.moneyhash.shared.datasource.network.model.common

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Enum class representing the status of the intent.
 *
 * - [PROCESSED] - Represents an intent that has been successfully processed.
 * - [UNPROCESSED] - Indicates that the intent is still pending and has not yet been handled.
 * - [TIME_EXPIRED] - Signifies that the intent has exceeded its time limit for processing.
 * - [CLOSED] - Depicts that the intent has been closed and no further actions can be taken.
 */
@Serializable
@CommonParcelize
enum class IntentStatus(val status: String): CommonParcelable {
    @SerialName("PROCESSED")
    PROCESSED("processed"),
    @SerialName("UNPROCESSED")
    UNPROCESSED("unprocessed"),
    @SerialName("TIME_EXPIRED")
    TIME_EXPIRED("timeExpired"),
    @SerialName("CLOSED")
    CLOSED("closed");

    companion object {
        fun from(status: String): IntentStatus {
            return entries.first { it.status == status }
        }
    }
}

@Serializable
@CommonParcelize
enum class IntentState(val state: String): CommonParcelable {
    @SerialName("METHOD_SELECTION")
    METHOD_SELECTION("methodSelection"),
    @SerialName("INTENT_FORM")
    INTENT_FORM("intentForm"),
    @SerialName("INTENT_PROCESSED")
    INTENT_PROCESSED("intentProcessed"),
    @SerialName("TRANSACTION_WAITING_USER_ACTION")
    TRANSACTION_WAITING_USER_ACTION("transactionWaitingUserAction"),
    @SerialName("TRANSACTION_FAILED")
    TRANSACTION_FAILED("transactionFailed"),
    @SerialName("EXPIRED")
    EXPIRED("expired"),
    @SerialName("CLOSED")
    CLOSED("closed"),
    @SerialName("FORM_FIELDS")
    FORM_FIELDS("formFields"),
    @SerialName("URL_TO_RENDER")
    URL_TO_RENDER("urlToRender"),
    @SerialName("SAVED_CARD_CVV")
    SAVED_CARD_CVV("savedCardCVV"),
    @SerialName("CARD_INTENT_SUCCESSFUL")
    SUCCESS("success"),
    @SerialName("CARD_INTENT_FAILED")
    FAILED("failed"),
    @SerialName("NATIVE_PAY")
    NATIVE_PAY("nativePay");

    companion object {
        fun from(state: String): IntentState {
            return entries.first { it.state == state }
        }
    }
}