package com.moneyhash.shared.datasource.network.model.common

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName

@kotlinx.serialization.Serializable
@CommonParcelize
data class TransactionOperation(
    @SerialName("amount")
    val amount: OperationAmount? = null,
    @SerialName("refund_type")
    val refundType: String? = null,
    @SerialName("statuses")
    val statuses: List<OperationStatus>? = null,
    @SerialName("id")
    val id: String? = null,
    @SerialName("type")
    val type: String? = null,
    @SerialName("status")
    val status: String? = null
) : CommonParcelable


@kotlinx.serialization.Serializable
@CommonParcelize
data class OperationStatus(
    @SerialName("code")
    val code: String? = null,
    @SerialName("created")
    val created: String? = null,
    @SerialName("id")
    val id: String? = null,
    @SerialName("message")
    val message: String? = null,
    @SerialName("value")
    val value: String? = null
) : CommonParcelable


@kotlinx.serialization.Serializable
@CommonParcelize
data class OperationAmount(
    @SerialName("currency")
    val currency: String? = null,
    @SerialName("value")
    val value: Double? = null
) : CommonParcelable



