package com.moneyhash.shared.datasource.network.model.discount

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.discount.DiscountItem
import com.moneyhash.shared.datasource.network.model.payment.Status
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable


@Serializable
@CommonParcelize
data class DiscountData(
    @SerialName("discount")
    val discount: DiscountItem? = null,
    @SerialName("amount")
    val amount: String? = null
): CommonParcelable

@Serializable
@CommonParcelize
data class DiscountResponse(
    @SerialName("data")
    val data: DiscountData? = null
): CommonParcelable