package com.moneyhash.shared.datasource.network.model.fees

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.common.Language
import com.moneyhash.shared.datasource.network.model.discount.DiscountItem
import kotlinx.serialization.EncodeDefault
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable


/**
 * Data class representing a fee item.
 *
 * @property title A map containing fee titles in multiple languages, where the keys are
 *                 instances of [Language] representing the language, and the values are
 *                 the respective titles in string format.
 *                 This allows for localization and display of fee information based on user preference.
 * @property value The value of the fee represented as a string (e.g., "5.00").
 *
 */
@Serializable
@CommonParcelize
data class FeeItem(
    @SerialName("title")
    val title: Map<Language, String>? = null,
    @SerialName("value")
    val value: String? = null,
    @EncodeDefault(EncodeDefault.Mode.NEVER)
    @SerialName("discount")
    val discount: DiscountItem? = null
): CommonParcelable



