package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.payment.billingfields.OptionItem
import com.moneyhash.shared.datasource.network.model.payment.billingfields.InputField
import com.moneyhash.shared.datasource.network.model.payment.billingfields.InputFieldType
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class FieldItem(
    @SerialName("min_length")
    val minLength: Int? = null,
    @SerialName("read_only")
    val readOnly: Boolean? = false,
    @SerialName("label")
    val label: String? = null,
    @SerialName("type")
    val type: String? = null,
    @SerialName("value")
    val value: String? = null,
    @SerialName("min_value")
    val minValue: Int? = null,
    @SerialName("max_value")
    val maxValue: Int? = null,
    @SerialName("max_string_length")
    val maxStringLength: String? = null,
    @SerialName("required")
    val required: Boolean? = false,
    @SerialName("error_messages")
    val errorMessages: ErrorMessagesData?,
    @SerialName("field_name")
    val fieldName: String? = null,
    @SerialName("max_length")
    val maxLength: Int? = 0,
    @SerialName("help_text")
    val helpText: String? = null,
    @SerialName("choices")
    val choices: Map<String, String>? = null,

): CommonParcelable

fun FieldItem.toInputField(
    optionsList: List<OptionItem>? = null,
    optionsMap: Map<String, List<OptionItem>>? = null,
    dependsOn:String? = null
): InputField {
    return InputField(
        type = InputFieldType.from(this.type.orEmpty()),
        name = this.fieldName,
        value = this.value,
        label = this.label,
        maxLength = this.maxLength,
        isRequired = this.required ?: false,
        optionsList = optionsList,
        optionsMap = optionsMap,
        hint = this.helpText,
        minLength = this.minLength,
        readOnly = this.readOnly ?: false,
        dependsOn = dependsOn
    )
}

