package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.util.Constants
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class NativePaymentData(
    @SerialName("country_code")
    val countryCode: String? = null,
    @SerialName("merchant_id")
    val merchantId: String? = null,
    @SerialName("currency_code")
    val currencyCode: String? = null,
    @SerialName("amount")
    val amount: Double? = null,
    @SerialName("supported_networks")
    val supportedNetworks: List<String>? = null
): CommonParcelable

@Serializable
@CommonParcelize
sealed class NativePayData: CommonParcelable {
    @Serializable
    @CommonParcelize
    @SerialName("apple_pay")
    data class ApplePayData(
        @SerialName("country_code")
        val countryCode: String? = null,
        @SerialName("merchant_id")
        val merchantId: String? = null,
        @SerialName("currency_code")
        val currencyCode: String? = null,
        @SerialName("amount")
        val amount: Double? = null,
        @SerialName("supported_networks")
        val supportedNetworks: List<String>? = null
    ): NativePayData(), CommonParcelable
}

fun NativePaymentData.toNativePayData(
    method: String
): NativePayData? {
    return when (method) {
        Constants.APPLE_PAY -> {
            NativePayData.ApplePayData(
                countryCode = this.countryCode,
                merchantId = this.merchantId,
                currencyCode = this.currencyCode,
                amount = this.amount,
                supportedNetworks = this.supportedNetworks
            )
        }

        else -> {
            null
        }
    }
}