package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.common.IntentStatus
import com.moneyhash.shared.datasource.network.model.fees.FeeItem
import com.moneyhash.shared.datasource.network.model.productItem.ProductItem
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class PaymentIntent(
    @SerialName("payment_methods")
    val paymentMethods: List<IntentMethodItem>? = null,
    @SerialName("amount")
    val amount: String? = null,
    @SerialName("subtotal_amount")
    val subtotalAmount: String? = null,
    @SerialName("total_discounts")
    val totalDiscounts: String? = null,
    @SerialName("expiration_date")
    val expirationDate: String? = null,
    @SerialName("formatted_amount")
    val formattedAmount: Double? = null,
    @SerialName("amount_currency")
    val amountCurrency: String? = null,
    @SerialName("secret")
    val secret: String? = null,
    @SerialName("is_live")
    val isLive: Boolean? = null,
    @SerialName("id")
    val id: String? = null,
    @SerialName("product_items")
    val productItems: List<ProductItem>? = null,
    @SerialName("fees")
    val fees: List<FeeItem>? = null,
    @SerialName("status")
    val status: IntentStatus? = null
): CommonParcelable
