package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.CommonRawValue
import com.moneyhash.shared.datasource.network.model.common.TransactionOperation
import com.moneyhash.shared.util.MoneyHashUtils
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject

@Serializable
@CommonParcelize
data class Transaction(
    @SerialName("billing_data")
    val billingData: @CommonRawValue JsonObject? = null,
    @SerialName("amount")
    val amount: Double? = null,
    @SerialName("external_action_message")
    val externalActionMessage: List<@CommonRawValue JsonElement>? = null,
    @SerialName("amount_currency")
    val amountCurrency: String? = null,
    @SerialName("id")
    val id: String? = null,
    @SerialName("payment_method_name")
    val paymentMethodName: String? = null,
    @SerialName("payment_method")
    val paymentMethod: String? = null,
    @SerialName("created")
    val createdDate: String? = null,
    @SerialName("status")
    val status: String? = null,
    @SerialName("operations")
    val operations: List<TransactionOperation>? = null,
    @SerialName("custom_fields")
    val customFields: @CommonRawValue JsonObject? = null,
    @SerialName("provider_transaction_fields")
    val providerTransactionFields: @CommonRawValue JsonObject? = null,
    @SerialName("custom_form_answers")
    val customFormAnswers: @CommonRawValue JsonObject? = null
): CommonParcelable {
    val billingDataString: String?
        get() = MoneyHashUtils.convertToString(billingData)

    val customFieldsString: String?
        get() = MoneyHashUtils.convertToString(customFields)

    val providerTransactionFieldsString: String?
        get() = MoneyHashUtils.convertToString(providerTransactionFields)

    val customFormAnswersString: String?
        get() = MoneyHashUtils.convertToString(customFormAnswers)

    val externalActionMessageString: List<String>?
        get() = MoneyHashUtils.convertToStringList(externalActionMessage)
}
