package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.EncodeDefault
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class UpdateMethodRequest(
    @EncodeDefault(EncodeDefault.Mode.NEVER)
    @SerialName("payment_method")
    val paymentMethod: String? = null,
    @EncodeDefault(EncodeDefault.Mode.NEVER)
    @SerialName("payout_method")
    val payoutMethod: String? = null,
    @EncodeDefault(EncodeDefault.Mode.NEVER)
    @SerialName("reset_intent")
    val resetIntent: Boolean? = null,
) : CommonParcelable
