package com.moneyhash.shared.datasource.network.model.payment.methods

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.payment.FieldItem
import com.moneyhash.shared.datasource.network.model.payment.IntentMethodItem
import com.moneyhash.shared.datasource.network.model.payment.billingfields.InputField
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
enum class MethodType(val type: String) : CommonParcelable {
    @SerialName("express_method")
    EXPRESS_METHOD("expressMethod"),

    @SerialName("customer_balance")
    CUSTOMER_BALANCE("customerBalance"),

    @SerialName("saved_card")
    SAVE_CARD("savedCard"),

    @SerialName("payment_method")
    PAYMENT_METHOD("paymentMethod"),

    @SerialName("payout_method")
    PAYOUT_METHOD("payoutMethod");

    companion object {
        fun from(methodName: String): MethodType {
            return entries.firstOrNull { it.type == methodName } ?: PAYMENT_METHOD
        }
    }
}

@Serializable
@CommonParcelize
data class CustomerBalance(
    @SerialName("balance")
    val balance: Double? = null,
    @SerialName("id")
    val id: String? = null,
    @SerialName("icon")
    val icon: String? = null,
    @SerialName("isSelected")
    val isSelected: Boolean? = null,
    @SerialName("type")
    val type: MethodType? = MethodType.CUSTOMER_BALANCE
) : CommonParcelable

@Serializable
@CommonParcelize
data class PaymentMethod(
    @SerialName("id")
    val id: String? = null,
    @SerialName("title")
    val title: String? = null,
    @SerialName("isSelected")
    val isSelected: Boolean? = null,
    @SerialName("confirmation_required")
    val confirmationRequired: Boolean? = null,
    @SerialName("icons")
    val icons: List<String>? = null,
    @SerialName("type")
    val type: MethodType? = MethodType.PAYMENT_METHOD,
    @SerialName("required_billing_fields")
    val requiredBillingFields: List<InputField>? = null
) : CommonParcelable

@Serializable
@CommonParcelize
data class PayoutMethod(
    @SerialName("id")
    val id: String? = null,
    @SerialName("title")
    val title: String? = null,
    @SerialName("isSelected")
    val isSelected: Boolean? = null,
    @SerialName("confirmation_required")
    val confirmationRequired: Boolean? = null,
    @SerialName("icons")
    val icons: List<String>? = null,
    @SerialName("type")
    val type: MethodType? = MethodType.PAYOUT_METHOD
) : CommonParcelable


@Serializable
@CommonParcelize
data class ExpressMethod(
    @SerialName("id")
    val id: String? = null,
    @SerialName("title")
    val title: String? = null,
    @SerialName("isSelected")
    val isSelected: Boolean? = null,
    @SerialName("confirmation_required")
    val confirmationRequired: Boolean? = null,
    @SerialName("icons")
    val icons: List<String>? = null,
    @SerialName("type")
    val type: MethodType? = MethodType.EXPRESS_METHOD,
    @SerialName("required_billing_fields")
    val requiredBillingFields: List<InputField>? = null
) : CommonParcelable

@Serializable
@CommonParcelize
data class SavedCard(
    @SerialName("id")
    val id: String? = null,
    @SerialName("brand")
    val brand: String? = null,
    @SerialName("last_4")
    val last4: String? = null,
    @SerialName("expiry_month")
    val expiryMonth: String? = null,
    @SerialName("expiry_year")
    val expiryYear: String? = null,
    @SerialName("country")
    val country: String? = null,
    @SerialName("logo")
    val logo: String? = null,
    @SerialName("require_cvv")
    val requireCvv: Boolean? = null,
    @SerialName("cvv_config")
    val cvvConfig: CvvConfig? = null,
    @SerialName("bin")
    val bin:String? = null,
    @SerialName("type")
    val type: MethodType? = MethodType.SAVE_CARD
) : CommonParcelable

@Serializable
@CommonParcelize
data class CvvConfig(
    @SerialName("digits_count")
    val digitsCount: Int? = 0
) : CommonParcelable

@Serializable
@CommonParcelize
data class IntentMethods(
    @SerialName("customer_balances")
    val customerBalances: List<CustomerBalance>? = null,
    @SerialName("payment_methods")
    val paymentMethods: List<PaymentMethod>? = null,
    @SerialName("express_methods")
    val expressMethods: List<ExpressMethod>? = null,
    @SerialName("saved_cards")
    val savedCards: List<SavedCard>? = null,
    @SerialName("payout_methods")
    val payoutMethods: List<PayoutMethod>? = null
) : CommonParcelable