package com.moneyhash.shared.datasource.network.model.productItem

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Data class representing an item in a product list or catalog.
 **
 * @property name The name of the product.
 * @property type The type of the product.
 * @property amount The price amount of the product, represented as a string.
 * @property category The main category to which the product belongs.
 * @property quantity The quantity of the product available or required.
 * @property description A description of the product that provides additional details.
 * @property subcategory A subcategory under which the product is classified.
 * @property referenceId An optional reference identifier for the product.
 *
 */
@Serializable
@CommonParcelize
data class ProductItem(
    @SerialName("name")
    val name: String? = null,
    @SerialName("type")
    val type: String? = null,
    @SerialName("amount")
    val amount: String? = null,
    @SerialName("category")
    val category: String? = null,
    @SerialName("quantity")
    val quantity: Int? = null,
    @SerialName("description")
    val description: String? = null,
    @SerialName("subcategory")
    val subcategory: String? = null,
    @SerialName("reference_id")
    val referenceId: String? = null
): CommonParcelable