package com.moneyhash.shared.datasource.network.model.vault

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.securevault.fields.FieldType
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class CardFieldState(
    @SerialName("isValid")
    val isValid: Boolean,
    @SerialName("errorMessage")
    val errorMessage: String? = null,
    @SerialName("formattedValue")
    val formattedValue: String,
    @SerialName("fieldType")
    val fieldType: FieldType,
    @SerialName("cardBrand")
    val cardBrand: CardBrand? = null,
    @SerialName("length")
    val length: Int? = null
) : CommonParcelable