package com.moneyhash.shared.datasource.network.model.vault

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * A data class representing the vault data for a the card.
 *
 * @property firstSixDigits The first six digits of the card number.
 * @property lastFourDigits The last four digits of the card number.
 * @property cardScheme The payment card scheme (e.g., VISA, MasterCard).
 * @property cardHolderName The name of the cardholder.
 * @property expiryYear The expiration year of the card.
 * @property expiryMonth The expiration month of the card.
 * @property isLive Indicates whether the card is live or not.
 * @property accessToken The access token for authorizing the card.
 * @property cardToken The token associated with the card for secure transactions.
 * @property cvv The CVV code for the card.
 * @property saveCard Indicates whether to save the card details for future use.
 * @property fingerprint A unique identifier for the card to prevent fraud.
 */
@Serializable
@CommonParcelize
data class VaultData(
    @SerialName("first_six_digits")
    val firstSixDigits: String?,
    @SerialName("last_four_digits")
    val lastFourDigits: String?,
    @SerialName("card_scheme") val
    cardScheme: String?,
    @SerialName("card_holder_name")
    val cardHolderName: String?,
    @SerialName("expiry_year")
    val expiryYear: String?,
    @SerialName("expiry_month")
    val expiryMonth: String?,
    @SerialName("is_live")
    val isLive: Boolean?,
    @SerialName("access_token")
    val accessToken: String?,
    @SerialName("card_token")
    val cardToken: String?,
    @SerialName("cvv")
    val cvv: String?,
    @SerialName("save_card")
    val saveCard: Boolean?,
    @SerialName("fingerprint")
    val fingerprint: String?
): CommonParcelable
