package com.moneyhash.shared.datasource.network.services

import com.moneyhash.shared.datasource.network.base.BaseService
import com.moneyhash.shared.datasource.network.model.auth.AuthResponse
import com.moneyhash.shared.datasource.network.model.auth.LoginRequest
import com.moneyhash.shared.datasource.services.AuthService

class AuthServiceImpl(
    private val authService: BaseService,
) : AuthService {
    @Throws(Throwable::class)
    override suspend fun login(email: String, password: String) = authService.post<AuthResponse> {
        endpoint("users/login")
        body(LoginRequest(email, password))
    }

}