package com.moneyhash.shared.datasource.network.services

import com.moneyhash.shared.datasource.network.base.BaseService
import com.moneyhash.shared.datasource.network.model.sandbox.DemoIntentResponse
import com.moneyhash.shared.datasource.services.SandboxService
import com.moneyhash.shared.util.Environment
import io.ktor.client.*
import io.ktor.client.call.*
import io.ktor.client.request.*

class SandboxServiceImpl(
    private val sandboxService: BaseService
) : SandboxService {

    @Throws(Throwable::class)
    override suspend fun getDemoIntents(accessToken: String): DemoIntentResponse {
        return sandboxService.get<DemoIntentResponse>() {
            header("Authorization", "Bearer $accessToken")
            endpoint("d/sandbox/demo-intents/")
        }
    }
}