package com.moneyhash.shared.datasource.network.services

import com.moneyhash.shared.datasource.network.base.BaseService
import com.moneyhash.shared.datasource.network.model.vault.CardFields
import com.moneyhash.shared.datasource.network.model.vault.VaultData
import com.moneyhash.shared.datasource.services.VaultService
import com.moneyhash.shared.util.Type

class VaultServiceImpl(
    private val vaultService: BaseService
): VaultService {
    @Throws(Throwable::class)
    override suspend fun postTokens(accessToken: String, cardDetails: CardFields): VaultData =
        vaultService.post<VaultData>() {
            endpoint(Type.VAULT.resultSuffix)
            header("Mh-Authorization", accessToken)
            body(cardDetails)
        }

}