package com.moneyhash.shared.datasource.services

import com.moneyhash.shared.datasource.network.model.StatusResponse
import com.moneyhash.shared.datasource.network.model.card.CardData
import com.moneyhash.shared.datasource.network.model.card.CardDetails
import com.moneyhash.shared.datasource.network.model.discount.DiscountItem
import com.moneyhash.shared.datasource.network.model.discount.DiscountResponse
import com.moneyhash.shared.datasource.network.model.fees.FeeItem
import com.moneyhash.shared.datasource.network.model.fees.FeesResponse
import com.moneyhash.shared.datasource.network.model.payment.PaymentInformation
import com.moneyhash.shared.datasource.network.model.payment.PaymentIntentData
import com.moneyhash.shared.datasource.network.model.payment.methods.PaymentMethodResponse
import com.moneyhash.shared.datasource.network.model.payout.PayoutDetails
import com.moneyhash.shared.datasource.network.model.vault.AccessTokenResponse
import com.moneyhash.shared.datasource.network.model.vault.VaultData
import kotlinx.serialization.json.JsonObject

interface PaymentService {
    @Throws(Throwable::class)
    suspend fun getPaymentInformation(
        paymentIntentId: String,
    ): PaymentIntentData

    @Throws(Throwable::class)
    suspend fun getCardInformation(
        cardIntentId: String,
    ): CardDetails

    @Throws(Throwable::class)
    suspend fun getPayoutInformation(
        payoutIntentId: String,
    ): PayoutDetails

    @Throws(Throwable::class)
    suspend fun useSelfWallet(paymentIntentId: String): PaymentIntentData
    @Throws(Throwable::class)
    suspend fun useSavedCard(paymentIntentId: String, cardTokenId: String, cvv: String?): PaymentIntentData
    @Throws(Throwable::class)
    suspend fun usePaymentMethod(intentId: String, methodName: String): PaymentIntentData
    @Throws(Throwable::class)
    suspend fun usePayoutMethod(intentId: String, methodName: String): PayoutDetails
    @Throws(Throwable::class)
    suspend fun deleteSavedCard(cardTokenId: String, secret: String): StatusResponse
    @Throws(Throwable::class)
    suspend fun resetPaymentSelectedMethod(paymentIntentId: String): PaymentIntentData
    @Throws(Throwable::class)
    suspend fun resetPayoutSelectedMethod(payoutIntentId: String): PayoutDetails
    @Throws(Throwable::class)
    suspend fun submitReceipt(paymentIntentId: String, receipt: String): PaymentInformation

    @Throws(Throwable::class)
    suspend fun submitForm(
        intentId: String,
        currentSelectedMethod: String,
        cardFields: JsonObject? = null,
        billingFields: JsonObject? = null,
        shippingFields: JsonObject? = null,
        vaultData: VaultData? = null
    ): PaymentIntentData

    @Throws(Throwable::class)
    suspend fun submitCardCVV(
        intentId: String,
        cvv: String
    ): PaymentIntentData

    @Throws(Throwable::class)
    suspend fun updateFees(
        intentId: String
        , fees: List<FeeItem>
    ): FeesResponse

    @Throws(Throwable::class)
    suspend fun updateDiscount(
        intentId: String,
        discount: DiscountItem
    ): DiscountResponse

    @Throws(Throwable::class)
    suspend fun generateAccessToken(publicKey: String): AccessTokenResponse

    @Throws(Throwable::class)
    suspend fun getMethods(
        publicKey: String,
        currency: String,
        amount: Double?,
        customer: String?,
        flowId: String?
    ): PaymentMethodResponse

    @Throws(Throwable::class)
    suspend fun createCardToken(
        cardIntentId: String,
        cardData: VaultData,
    ): CardDetails
}