package com.moneyhash.shared.di

import kotlinx.atomicfu.atomic

object MoneyHashStore {
    private val _publicKey = atomic<String?>(null)

    // Internal getter
    internal val publicKey: String?
        get() = _publicKey.value

    // Internal setter
    fun setPublicKey(value: String?) {
        _publicKey.value = value
    }
}
