package com.moneyhash.shared.di

import com.moneyhash.shared.datasource.network.KtorClientFactory
import com.moneyhash.shared.datasource.network.base.BaseService
import com.moneyhash.shared.datasource.network.services.AuthServiceImpl
import com.moneyhash.shared.datasource.network.services.PaymentServiceImpl
import com.moneyhash.shared.datasource.network.services.SandboxServiceImpl
import com.moneyhash.shared.datasource.network.services.VaultServiceImpl
import com.moneyhash.shared.datasource.services.AuthService
import com.moneyhash.shared.datasource.services.PaymentService
import com.moneyhash.shared.datasource.services.SandboxService
import com.moneyhash.shared.util.Environment

class NetworkModule(
    private val environment: Environment,
    enableLogs: Boolean,
    sdkVersion: String
) {
    private val httpClient = KtorClientFactory().build(
        enableLogs = environment.debuggable || enableLogs,
        sdkVersion = sdkVersion
    )

    private val ktorClientFactory = KtorClientFactory()

    private val baseService by lazy {
        BaseService(
            ktorClientFactory.build(environment == Environment.Staging || enableLogs, sdkVersion),
            environment.baseUrl
        )
    }

    private val baseVaultService by lazy {
        BaseService(
            ktorClientFactory.build(environment == Environment.Staging || enableLogs, sdkVersion),
            environment.vaultUrl
        )
    }
    val paymentService: PaymentService by lazy {
        PaymentServiceImpl(
            paymentService = baseService
        )
    }

    val authService: AuthService by lazy {
        AuthServiceImpl(authService = baseService)
    }

    val sandboxService: SandboxService by lazy {
        SandboxServiceImpl(
            sandboxService = baseService
        )
    }

    val vaultService: VaultServiceImpl by lazy {
        VaultServiceImpl(
            vaultService = baseVaultService
        )
    }
}
