package com.moneyhash.shared.domain.util

import com.moneyhash.shared.errorhandling.MHThrowable

data class DataState<T>(
    val data: T? = null,
    val error: MHThrowable? = null,
    val isLoading: Boolean = false,
) {

    companion object {
        fun <T> data(data: T? = null): DataState<T> {
            return DataState(data = data)
        }

        fun <T> error(
            error: MHThrowable,
        ): DataState<T> {
            return DataState(
                error = error,
                data = null,
            )
        }

        fun <T> loading() = DataState<T>(isLoading = true)
    }
}
