package com.moneyhash.shared.errorhandling

import com.moneyhash.shared.localization.LocalizationManager

object ErrorMapperConstants {
    const val UNEXPECTED = -102
    const val UNAUTHORIZED = 401
    const val NO_INTERNET_CONNECTION = 4232
    const val SOMETHING_WRONG = 4222
    val NO_INTERNET_CONNECTION_MESSAGE = LocalizationManager.strings.no_internet_connection
    val SOMETHING_WRONG_MESSAGE = LocalizationManager.strings.something_wrong
}

object ErrorMapper {
    fun mapThrowable(throwable: Throwable): MHThrowable {
        if (throwable is MHThrowable) {
            return throwable
        }

        return MHThrowable(
            message = throwable.message ?: throwable.toString(),
            type = ErrorType.UNKNOWN
        )
    }

    fun mapToMHThrowable(
        throwable: Throwable,
        errorMessage: String?
    ): MHThrowable {
        return MHThrowable(
            message = errorMessage ?: throwable.message ?: throwable.toString(),
            type = ErrorType.UNKNOWN
        )
    }

    fun mapServerError(
        errorMessage: String?,
        errors: List<ErrorInfo>,
        throwable: Throwable
    ): MHThrowable {
        return MHThrowable(
            message = errorMessage ?: ErrorMapperConstants.SOMETHING_WRONG_MESSAGE,
            errors = errors,
            type = ErrorType.NETWORK
        )
    }

    fun mapToMHThrowable(
        errorMessage: String
    ): MHThrowable {
        return MHThrowable(
            message = errorMessage,
            type = ErrorType.UNKNOWN
        )
    }
}

inline fun <reified T> executeCatching(block: () -> T): T {
    try {
        return block()
    } catch (e: Throwable) {
        throw ErrorMapper.mapThrowable(e)
    }
}