package com.moneyhash.shared.errorhandling

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
open class MHThrowable(
    @SerialName("message")
    override val message: String? = null,
    @SerialName("errors")
    val errors: List<ErrorInfo> = listOf(),
    @SerialName("type")
    val type: ErrorType
) : CommonParcelable, Throwable(message)


@Serializable
@CommonParcelize
data class ErrorInfo(
    @SerialName("key")
    val key: String,
    @SerialName("message")
    val message: String
) : CommonParcelable

@Serializable
@CommonParcelize
enum class ErrorType : CommonParcelable {
    @SerialName("network")
    NETWORK,

    @SerialName("unknown")
    UNKNOWN,

    @SerialName("card_validation")
    CARD_VALIDATION,

    @SerialName("cancelled")
    CANCELLED
}
