package com.moneyhash.shared.localization

enum class Locale {
    En,
    Ar,
    Fr;

    companion object {
        fun localizedStrings(locale: Locale): Strings {
            return when (locale) {
                Locale.En -> EnStrings()
                Locale.Ar -> ArStrings()
                Locale.Fr -> FrStrings()
            }
        }
    }
}
