package com.moneyhash.shared.securevault.exceptions

import com.moneyhash.shared.errorhandling.ErrorType
import com.moneyhash.shared.errorhandling.MHThrowable

sealed class ValidationException(message: String) : MHThrowable(message, type = ErrorType.CARD_VALIDATION) {
    class RangeValueValidationException(message: String) : ValidationException(message)
    class AlphabetValidationException(message: String) : ValidationException(message)
    class NumericValidationException(message: String) : ValidationException(message)
    class LuhnException(message: String) : ValidationException(message)
    class LengthException(message: String) : ValidationException(message)
    class EmptyValueException(message: String) : ValidationException(message)
}