package com.moneyhash.shared.securevault.exceptions

import com.moneyhash.shared.errorhandling.ErrorType
import com.moneyhash.shared.errorhandling.MHThrowable
import com.moneyhash.shared.localization.LocalizationManager

sealed class VaultCollectNetworkError(message: String) : MHThrowable(message, type =  ErrorType.NETWORK) {
    object MissingPublicKey: VaultCollectNetworkError(LocalizationManager.strings.required_public_api_key_generate_token)

    object TokenizationError : VaultCollectNetworkError(LocalizationManager.strings.tokenizing_card_error)
}
