package com.moneyhash.shared.securevault.fields

import com.moneyhash.shared.datasource.network.model.vault.CardFieldState
import com.moneyhash.shared.securevault.Weak
import com.moneyhash.shared.securevault.collectors.CardCollector
import com.moneyhash.shared.util.DefaultLogManager

class SecureTextFieldVM(
    private val configuration: SecureTextFieldConfiguration
)  {

    private var collector: Weak<CardCollector>? = null
    private var currentStateInternal: CardFieldState? = null

    val currentState: CardFieldState?
        get() = currentStateInternal

    init {
        DefaultLogManager.info("Initializing SecureTextFieldVM with configuration type: ${configuration.type}")
        configuration.collector.registerField(configuration.type, this)
    }

    fun set(value: String) {
        DefaultLogManager.debug("Setting value: $value")
        currentStateInternal = collector?.get()?.updateField(configuration.type, value)
    }

    fun setCollector(collector: Weak<CardCollector>) {
        DefaultLogManager.info("Setting collector for SecureTextFieldVM")
        this.collector = collector
    }

}
