package com.moneyhash.shared.securevault.formatters

internal class AlphabetOnlyFormat : BaseFormat() {
    private val allowedCharacterSet = ('A'..'Z') + ('a'..'z') + ' '
    override fun format(text: String): String {
        val filteredString = text.filter { it in allowedCharacterSet }
        return nextFormatter?.format(filteredString) ?: filteredString
    }
}