package com.moneyhash.shared.securevault.formatters

internal open class BaseFormat : TextFormatter {

    var nextFormatter: TextFormatter? = null
        private set

    /**
     * Sets the next formatter in the chain.
     */
    fun setNextFormatter(formatter: TextFormatter) {
        this.nextFormatter = formatter
    }

    override fun format(text: String): String {
        return nextFormatter?.format(text) ?: text
    }

    override fun removeFormat(text: String): String {
        return nextFormatter?.removeFormat(text) ?: text
    }
}
