package com.moneyhash.shared.securevault.formatters

import com.moneyhash.shared.securevault.models.CardBrandInternal

// Assuming CardBrand and BaseFormat are already defined as provided

internal class CardFormat(private val cardBrandInternal: CardBrandInternal) : BaseFormat() {

    override fun format(text: String): String {
        val pattern = cardBrandInternal.defaultFormatPattern()
        val formatted = StringBuilder()
        var textIndex = 0

        for (patternChar in pattern) {
            if (patternChar == '#') {
                if (textIndex < text.length) {
                    formatted.append(text[textIndex])
                    textIndex++
                }
            } else {
                if (textIndex < text.length) {
                    formatted.append(patternChar)
                }
            }
        }

        return nextFormatter?.format(formatted.toString()) ?: formatted.toString()
    }

    override fun removeFormat(text: String): String {
        val removeFormat = text
            .replace(" ", "")
            .replace("-", "")
            .replace("/", "")
        return nextFormatter?.removeFormat(removeFormat) ?: removeFormat
    }
}
