package com.moneyhash.shared.securevault.formatters

internal class CardHolderNameFormatter : TextFormatter {
    private val formatter: TextFormatter

    init {
        val limitFormat = LimitFormat(20)
        val onlyAlphabetFormat = AlphabetOnlyFormat()

        limitFormat.setNextFormatter(onlyAlphabetFormat)
        formatter = limitFormat
    }

    override fun format(text: String): String {
        return formatter.format(text)
    }

    override fun removeFormat(text: String): String {
        return formatter.removeFormat(text)
    }
}