package com.moneyhash.shared.securevault.formatters

import com.moneyhash.shared.securevault.models.CardBrandInternal

internal class CardNumberFormatter(private val cardBrandInternal: CardBrandInternal) : TextFormatter {
    private val formatter: TextFormatter

    init {
        val numericFormat = NumericFormat()
        val limitFormat = LimitFormat(cardBrandInternal.defaultCardLengths().max())
        val cardFormat = CardFormat(cardBrandInternal)

        numericFormat.setNextFormatter(limitFormat)
        limitFormat.setNextFormatter(cardFormat)
        formatter = numericFormat
    }

    override fun format(text: String): String {
        return formatter.format(text)
    }

    override fun removeFormat(text: String): String {
        return formatter.removeFormat(text)
    }
}