package com.moneyhash.shared.securevault.formatters

internal class ExpireMonthFormatter : TextFormatter {
    private val formatter: TextFormatter

    init {
        val limitFormat = LimitFormat(2)
        val numericFormat = NumericFormat()
        val zeroLeadingFormat = ZeroLeadingFormat()

        numericFormat.setNextFormatter(zeroLeadingFormat)
        zeroLeadingFormat.setNextFormatter(limitFormat)
        formatter = numericFormat
    }

    override fun format(text: String): String {
        return formatter.format(text)
    }

    override fun removeFormat(text: String): String {
        return formatter.removeFormat(text)
    }
}

internal class ZeroLeadingFormat : BaseFormat() {
    override fun format(text: String): String {
        val formatted = text
            .replace(Regex("^([2-9])"), "0$1") // Add a leading zero for numbers starting with 2-9
            .replace(Regex("^1[3-9]"), "01") // Convert numbers like 13-19 to 01
            .replace(Regex("^00"), "0") // Convert "00" to "0"


        return nextFormatter?.format(formatted) ?: formatted
    }
}