package com.moneyhash.shared.securevault.validators

internal open class BaseValidator : Validator {
    private var nextValidator: Validator? = null

    /**
     * Sets the next validator in the chain.
     */
    fun setNextValidator(validator: Validator) {
        this.nextValidator = validator
    }

    @Throws(Throwable::class)
    override fun validate(text: String): Boolean {
        return nextValidator?.validate(text) ?: true
    }
}