package com.moneyhash.shared.securevault.validators

import com.moneyhash.shared.securevault.models.CardBrandInternal

internal class CreditCardValidator(private val cardBrandInternal: CardBrandInternal) : Validator {
    private val validator: Validator

    init {
        val lengthValidator = LengthValidator(cardBrandInternal.defaultCardLengths())
        val luhnValidator = LuhnValidator()
        val numericValidator = NumericValidator()

        numericValidator.setNextValidator(lengthValidator)
        if (cardBrandInternal != CardBrandInternal.UNIONPAY) {
            lengthValidator.setNextValidator(luhnValidator)
        }
        validator = numericValidator
    }

    @Throws(Throwable::class)
    override fun validate(text: String): Boolean {
        return validator.validate(text)
    }
}
