package com.moneyhash.shared.securevault.validators

internal class ExpireMonthValidator : Validator {
    private val validator: Validator

    init {
        val lengthValidator = LengthValidator((2..2).toList())
        val numericValidator = NumericValidator()
        val valueValidator = RangeValueValidator(1..12)

        numericValidator.setNextValidator(lengthValidator)
        lengthValidator.setNextValidator(valueValidator)
        validator = numericValidator
    }

    @Throws(Throwable::class)
    override fun validate(text: String): Boolean {
        return validator.validate(text)
    }
}
