package com.moneyhash.shared.securevault.validators
import kotlinx.datetime.*

internal class ExpireYearValidator : Validator {
    private val validator: Validator

    init {
        val lengthValidator = LengthValidator((2..2).toList())
        val numericValidator = NumericValidator()
        val valueValidator = RangeValueValidator(getCurrentYearYY()..(getCurrentYearYY() + 10))

        numericValidator.setNextValidator(lengthValidator)
        lengthValidator.setNextValidator(valueValidator)
        validator = numericValidator
    }

    @Throws(Throwable::class)
    override fun validate(text: String): Boolean {
        return validator.validate(text)
    }
}


fun getCurrentYearYY(): Int {
    val currentYear = Clock.System.now().toLocalDateTime(TimeZone.currentSystemDefault()).year
    return currentYear % 100
}
