package com.moneyhash.shared.securevault.validators

import com.moneyhash.shared.localization.LocalizationManager
import com.moneyhash.shared.securevault.exceptions.ValidationException
import com.moneyhash.shared.util.DefaultLogManager

internal class LengthValidator(private val validLengths: List<Int>) : BaseValidator() {
    override fun validate(text: String): Boolean {
        DefaultLogManager.info("Validating length for text: '${text}'")
        if (!validLengths.contains(text.length)) {
            val message = LocalizationManager.strings.input_length_error("${text.length}", "$validLengths")
            DefaultLogManager.error(message)
            throw ValidationException.LengthException(message)
        }
        DefaultLogManager.info("Validation successful: The length of the input text (${text.length}) is valid.")
        return super.validate(text)
    }
}