package com.moneyhash.shared.securevault.validators

import com.moneyhash.shared.localization.LocalizationManager
import com.moneyhash.shared.securevault.exceptions.ValidationException
import com.moneyhash.shared.util.DefaultLogManager

internal class NumericValidator : BaseValidator() {
    override fun validate(text: String): Boolean {
        DefaultLogManager.info("Validating numeric value for text: '$text'")

        if (text.trim().isEmpty()) {
            val message = LocalizationManager.strings.input_empty
            DefaultLogManager.error(message)
            throw ValidationException.EmptyValueException(message)
        }

        if (text.any { !it.isDigit() }) {
            val message = "The input text contains non-numeric characters."
            DefaultLogManager.error(message)
            throw ValidationException.NumericValidationException(LocalizationManager.strings.input_non_numeric)
        }

        DefaultLogManager.info("Validation successful: The input text is purely numeric.")
        return super.validate(text)
    }
}