package com.moneyhash.shared.util

import com.moneyhash.shared.datasource.network.model.payment.IntentStateDetails
import com.moneyhash.shared.util.extensions.toStringContent
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject

object MoneyHashUtils {
    fun convertToString(item: JsonObject?): String? {
        return item?.let { Json.encodeToString(it) }
    }

    fun convertToStringList(items: List<JsonElement>?): List<String>? {
        return items?.toStringContent()
    }

    fun getIntentStateDetailsJson(state: IntentStateDetails): String {
        return Json.encodeToString(state)
    }
}