/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.dynamodb.repository;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.RepositoryIndexable;
import io.mongock.driver.dynamodb.repository.DynamoDbRepositoryBaseKt;
import io.mongock.utils.Process;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lio/mongock/driver/dynamodb/repository/DynamoDbRepositoryBase;", "Lio/mongock/utils/Process;", "Lio/mongock/driver/api/common/RepositoryIndexable;", "client", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;", "tableName", "", "mapperClass", "Lkotlin/reflect/KClass;", "indexCreation", "", "provisionedThroughput", "Lcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;", "(Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;Ljava/lang/String;Lkotlin/reflect/KClass;ZLcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;)V", "getClient", "()Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;", "dynamoDB", "Lcom/amazonaws/services/dynamodbv2/document/DynamoDB;", "ensuredIndex", "initialize", "", "getInitialize", "()Lkotlin/Unit;", "initialize$delegate", "Lkotlin/Lazy;", "mapper", "Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "getMapper", "()Lcom/amazonaws/services/dynamodbv2/datamodeling/DynamoDBMapper;", "table", "Lcom/amazonaws/services/dynamodbv2/document/Table;", "getTableName", "()Ljava/lang/String;", "createTable", "retrieveTable", "setIndexCreation", "dynamodb-driver"})
public abstract class DynamoDbRepositoryBase
implements Process,
RepositoryIndexable {
    @NotNull
    private final AmazonDynamoDBClient client;
    @NotNull
    private final String tableName;
    @NotNull
    private final KClass<?> mapperClass;
    private boolean indexCreation;
    @Nullable
    private final ProvisionedThroughput provisionedThroughput;
    @NotNull
    private final DynamoDBMapper mapper;
    @NotNull
    private final DynamoDB dynamoDB;
    private Table table;
    private boolean ensuredIndex;
    @NotNull
    private final Lazy initialize$delegate;

    public DynamoDbRepositoryBase(@NotNull AmazonDynamoDBClient client, @NotNull String tableName, @NotNull KClass<?> mapperClass, boolean indexCreation, @Nullable ProvisionedThroughput provisionedThroughput) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(mapperClass, (String)"mapperClass");
        this.client = client;
        this.tableName = tableName;
        this.mapperClass = mapperClass;
        this.indexCreation = indexCreation;
        this.provisionedThroughput = provisionedThroughput;
        this.mapper = new DynamoDBMapper((AmazonDynamoDB)this.client, DynamoDbRepositoryBaseKt.access$mapperConfig(this.tableName));
        this.dynamoDB = new DynamoDB((AmazonDynamoDB)this.client);
        this.initialize$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DynamoDbRepositoryBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DynamoDbRepositoryBaseKt.access$getLogger$p().debug((Function0)new Function0<Object>(this.this$0){
                    final /* synthetic */ DynamoDbRepositoryBase this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "initializing [" + this.this$0.getTableName() + ']';
                    }
                });
                if (!DynamoDbRepositoryBase.access$getEnsuredIndex$p(this.this$0)) {
                    DynamoDbRepositoryBase.access$setTable$p(this.this$0, DynamoDbRepositoryBase.access$retrieveTable(this.this$0));
                    DynamoDbRepositoryBase.access$setEnsuredIndex$p(this.this$0, true);
                }
            }
        }));
    }

    @NotNull
    protected final AmazonDynamoDBClient getClient() {
        return this.client;
    }

    @NotNull
    protected final String getTableName() {
        return this.tableName;
    }

    @NotNull
    protected final DynamoDBMapper getMapper() {
        return this.mapper;
    }

    private final Unit getInitialize() {
        Lazy lazy = this.initialize$delegate;
        lazy.getValue();
        return Unit.INSTANCE;
    }

    public void initialize() {
        this.getInitialize();
    }

    private final Table retrieveTable() {
        Table table;
        try {
            Table table2 = this.dynamoDB.getTable(this.tableName);
            table2.describe();
            table = table2;
            Intrinsics.checkNotNullExpressionValue((Object)table, (String)"{\n        val table = dy\u2026eated\n        table\n    }");
        }
        catch (ResourceNotFoundException ex) {
            DynamoDbRepositoryBaseKt.access$getLogger$p().info((Function0)new Function0<Object>(this){
                final /* synthetic */ DynamoDbRepositoryBase this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Table[" + this.this$0.getTableName() + "] not created";
                }
            });
            table = this.createTable();
        }
        return table;
    }

    private final Table createTable() {
        DynamoDbRepositoryBaseKt.access$getLogger$p().info((Function0)new Function0<Object>(this){
            final /* synthetic */ DynamoDbRepositoryBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "...creating table[" + this.this$0.getTableName() + ']';
            }
        });
        if (!this.indexCreation) {
            throw new MongockException("Table creation not allowed, but not created or wrongly created for table[" + this.tableName + ']');
        }
        CreateTableRequest createTableRequest = this.mapper.generateCreateTableRequest(JvmClassMappingKt.getJavaClass(this.mapperClass));
        Table table = this.provisionedThroughput != null ? this.dynamoDB.createTable(createTableRequest.withProvisionedThroughput(this.provisionedThroughput)) : this.dynamoDB.createTable(createTableRequest);
        DynamoDbRepositoryBaseKt.access$getLogger$p().info((Function0)new Function0<Object>(this){
            final /* synthetic */ DynamoDbRepositoryBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Waiting until[" + this.this$0.getTableName() + "] is active";
            }
        });
        TableUtils.waitUntilActive((AmazonDynamoDB)((AmazonDynamoDB)this.client), (String)this.tableName);
        DynamoDbRepositoryBaseKt.access$getLogger$p().info((Function0)new Function0<Object>(this){
            final /* synthetic */ DynamoDbRepositoryBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Table[" + this.this$0.getTableName() + "] created";
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)table, (String)"table");
        return table;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    public static final /* synthetic */ boolean access$getEnsuredIndex$p(DynamoDbRepositoryBase $this) {
        return $this.ensuredIndex;
    }

    public static final /* synthetic */ void access$setTable$p(DynamoDbRepositoryBase $this, Table table) {
        $this.table = table;
    }

    public static final /* synthetic */ Table access$retrieveTable(DynamoDbRepositoryBase $this) {
        return $this.retrieveTable();
    }

    public static final /* synthetic */ void access$setEnsuredIndex$p(DynamoDbRepositoryBase $this, boolean bl) {
        $this.ensuredIndex = bl;
    }
}

