/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.util.logger;

public interface CliLogger {
    default public void trace(String format, Object ... arguments) {
        this.print(Level.TRACE, format, arguments);
    }

    default public void debug(String format, Object ... arguments) {
        this.print(Level.DEBUG, format, arguments);
    }

    default public void info(String format, Object ... arguments) {
        this.print(Level.INFO, format, arguments);
    }

    default public void warn(String format, Object ... arguments) {
        this.print(Level.WARN, format, arguments);
    }

    default public void error(String format, Object ... arguments) {
        this.print(Level.ERROR, format, arguments);
    }

    public void print(Level var1, String var2, Object ... var3);

    public static enum Level {
        TRACE(1),
        DEBUG(2),
        WARN(3),
        INFO(4),
        ERROR(5),
        NONE(6);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        boolean isGreaterEqual(Level that) {
            return this.level >= that.level;
        }

        public static Level fromStringDefaultInfo(String targetLevel) {
            return Level.fromString(targetLevel, INFO);
        }

        public static Level fromString(String targetLevel, Level defaultLevel) {
            for (Level itemLevel : Level.values()) {
                if (!itemLevel.name().equalsIgnoreCase(targetLevel)) continue;
                return itemLevel;
            }
            return defaultLevel;
        }
    }
}

