/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.operation.change;

import com.google.gson.Gson;
import io.mongock.api.config.TransactionStrategy;
import io.mongock.api.config.executor.ChangeExecutorConfiguration;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.driver.api.entry.ExecutedChangeEntry;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.runner.core.executor.Executor;
import io.mongock.runner.core.executor.changelog.ChangeLogRuntime;
import io.mongock.runner.core.internal.BeforeChangeSetItem;
import io.mongock.runner.core.internal.ChangeLogItem;
import io.mongock.runner.core.internal.ChangeSetItem;
import io.mongock.utils.StringUtils;
import io.mongock.utils.Triple;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class MigrationExecutorBase<CONFIG extends ChangeExecutorConfiguration>
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(MigrationExecutorBase.class);
    protected final Boolean globalTransactionEnabled;
    protected final Deque<Triple<Object, ChangeSetItem, Exception>> changeSetsToRollBack = new ArrayDeque<Triple<Object, ChangeSetItem, Exception>>();
    protected final ConnectionDriver driver;
    protected final String serviceIdentifier;
    protected final boolean trackIgnored;
    protected final Set<ChangeLogItem<ChangeSetItem>> changeLogs;
    protected final Map<String, Object> metadata;
    private final ChangeLogRuntime changeLogRuntime;
    private final String defaultAuthor;
    protected boolean executionInProgress = false;
    protected final String executionId;
    private final TransactionStrategy transactionStrategy;
    protected List<ExecutedChangeEntry> executedChangeEntries = null;

    public MigrationExecutorBase(String executionId, Set<ChangeLogItem<ChangeSetItem>> changeLogs, ConnectionDriver driver, ChangeLogRuntime changeLogRuntime, CONFIG config) {
        this.executionId = executionId;
        this.driver = driver;
        this.changeLogRuntime = changeLogRuntime;
        this.metadata = config.getMetadata();
        this.serviceIdentifier = config.getServiceIdentifier();
        this.trackIgnored = config.isTrackIgnored();
        this.changeLogs = changeLogs;
        this.globalTransactionEnabled = config.getTransactionEnabled().orElse(null);
        this.transactionStrategy = config.getTransactionStrategy();
        this.defaultAuthor = config.getDefaultMigrationAuthor();
    }

    @Override
    public boolean isExecutionInProgress() {
        return this.executionInProgress;
    }

    /*
     * Loose catch block
     */
    @Override
    public Boolean executeMigration() {
        this.initializationAndValidation();
        try {
            Boolean bl;
            try (LockManager lockManager = this.driver.getLockManager();){
                this.loadExecutedChangeEntries();
                if (!this.isThereAnyChangeSetItemToBeExecuted(this.changeLogs)) {
                    logger.info("Mongock skipping the data migration. All change set items are already executed or there is no change set item.");
                    Boolean bl2 = false;
                    return bl2;
                }
                lockManager.acquireLockDefault();
                this.loadExecutedChangeEntries();
                String executionHostname = this.generateExecutionHostname(this.executionId);
                logger.info("Mongock starting the data migration sequence id[{}]...", (Object)this.executionId);
                this.processMigration(this.changeLogs, this.executionId, executionHostname);
                bl = true;
            }
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.executionInProgress = false;
            logger.info("Mongock has finished");
        }
    }

    protected void processMigration(Collection<ChangeLogItem<ChangeSetItem>> changeLogs, String executionId, String executionHostname) {
        this.prepareForStageExecutionIfApply(this.isStrategyPerMigration());
        this.driver.getTransactioner().filter(t -> this.isStrategyPerMigration() && this.isDriverTransactional()).orElse(Runnable::run).executeInTransaction(() -> this.processChangeLogs(executionId, executionHostname, changeLogs));
    }

    protected void processChangeLogs(String executionId, String executionHostname, Collection<ChangeLogItem<ChangeSetItem>> changeLogs) {
        for (ChangeLogItem<ChangeSetItem> changeLog : changeLogs) {
            this.processSingleChangeLog(executionId, executionHostname, changeLog);
        }
    }

    protected void processSingleChangeLog(String executionId, String executionHostname, ChangeLogItem<ChangeSetItem> changeLog) {
        block2: {
            try {
                this.prepareForStageExecutionIfApply(this.isStrategyPerChangeUnit() && changeLog.isTransactional());
                Object changeLogInstance = this.getChangeLogInstance(changeLog.getType());
                this.loopRawChangeSets(executionId, executionHostname, changeLogInstance, changeLog, changeLog.getBeforeItems());
                this.processChangeLogInTransactionIfApplies(executionId, executionHostname, changeLogInstance, changeLog);
                this.clearChangeSetsToRollbackIfApply(this.isStrategyPerChangeUnit());
            }
            catch (Exception e) {
                if (!changeLog.isFailFast()) break block2;
                this.rollbackProcessedChangeSetsIfApply(executionId, executionHostname, this.changeSetsToRollBack);
                throw e;
            }
        }
    }

    protected Object getChangeLogInstance(Class<?> changeLogClass) {
        this.injectDependenciesFromDriver();
        return this.changeLogRuntime.getInstance(changeLogClass);
    }

    protected void processChangeLogInTransactionIfApplies(String executionId, String executionHostname, Object changeLogInstance, ChangeLogItem<ChangeSetItem> changeLog) {
        this.driver.getTransactioner().filter(c -> this.isDriverTransactional() && this.isStrategyPerChangeUnit() && changeLog.isTransactional()).orElse(Runnable::run).executeInTransaction(() -> this.loopRawChangeSets(executionId, executionHostname, changeLogInstance, changeLog, changeLog.getChangeSetItems()));
    }

    protected void loopRawChangeSets(String executionId, String executionHostName, Object changeLogInstance, ChangeLogItem<ChangeSetItem> changeLog, List<? extends ChangeSetItem> changeSets) {
        for (ChangeSetItem changeSetItem : changeSets) {
            if (!this.isDriverTransactional() || this.isStrategyPerChangeUnit() && (changeSetItem instanceof BeforeChangeSetItem || !changeLog.isTransactional())) {
                this.changeSetsToRollBack.push((Triple<Object, ChangeSetItem, Exception>)new Triple(changeLogInstance, (Object)changeSetItem, null));
            }
            this.processSingleChangeSet(executionId, executionHostName, changeLogInstance, changeSetItem);
        }
    }

    protected void rollbackProcessedChangeSetsIfApply(String executionId, String hostname, Deque<Triple<Object, ChangeSetItem, Exception>> processedChangeSets) {
        logger.info("Mongock migration aborted and DB transaction not enabled. Starting manual rollback process");
        processedChangeSets.forEach(triple -> {
            try {
                this.rollbackIfPresentAndTrackChangeEntry(executionId, hostname, triple.getFirst(), (ChangeSetItem)triple.getSecond(), (Exception)triple.getThird());
            }
            catch (Exception e) {
                throw e instanceof MongockException ? (MongockException)e : new MongockException((Throwable)e);
            }
        });
    }

    protected void processSingleChangeSet(String executionId, String executionHostname, Object changeLogInstance, ChangeSetItem changeSet) {
        try {
            this.executeAndLogChangeSet(executionId, executionHostname, changeLogInstance, changeSet);
        }
        catch (Exception e) {
            this.processExceptionOnChangeSetExecution(e, changeSet, changeSet.isFailFast());
        }
    }

    protected String generateExecutionHostname(String executionId) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostname = "unknown-host." + executionId;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.serviceIdentifier)) {
            hostname = hostname + "-";
            hostname = hostname + this.serviceIdentifier;
        }
        return hostname;
    }

    protected boolean isThereAnyChangeSetItemToBeExecuted(Collection<ChangeLogItem<ChangeSetItem>> changeLogs) {
        return changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).anyMatch(changeSetItem -> changeSetItem.isRunAlways() || !this.isAlreadyExecuted((ChangeSetItem)changeSetItem));
    }

    protected boolean isAlreadyExecuted(ChangeSetItem changeSetItem) {
        return this.executedChangeEntries.stream().anyMatch(changeEntry -> changeEntry.getChangeId().equals(changeSetItem.getId()) && changeEntry.getAuthor().equals(changeSetItem.getAuthor()));
    }

    protected void executeAndLogChangeSet(String executionId, String executionHostname, Object changelogInstance, ChangeSetItem changeSetItem) throws IllegalAccessException, InvocationTargetException {
        ChangeEntry changeEntry = null;
        boolean alreadyExecuted = false;
        ChangeType type = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
        try {
            alreadyExecuted = this.isAlreadyExecuted(changeSetItem);
            if (!alreadyExecuted || changeSetItem.isRunAlways()) {
                logger.debug("executing changeSet[{}]", (Object)changeSetItem.getId());
                long executionTimeMillis = this.executeChangeSetMethod(changeSetItem.getMethod(), changelogInstance);
                changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, executionTimeMillis, ChangeState.EXECUTED, type);
                logger.debug("successfully executed changeSet[{}]", (Object)changeSetItem.getId());
            } else {
                changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, ChangeState.IGNORED, type);
            }
            if (changeEntry != null) {
                this.logChangeEntry(changeEntry, changeSetItem, alreadyExecuted);
                this.trackChangeEntry(changeSetItem, changeEntry, alreadyExecuted);
            }
        }
        catch (Exception ex) {
            try {
                logger.debug("failure when executing changeSet[{}]", (Object)changeSetItem.getId());
                changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, ChangeState.FAILED, type, ex, null);
                throw ex;
            }
            catch (Throwable throwable) {
                if (changeEntry != null) {
                    this.logChangeEntry(changeEntry, changeSetItem, alreadyExecuted);
                    this.trackChangeEntry(changeSetItem, changeEntry, alreadyExecuted);
                }
                throw throwable;
            }
        }
    }

    private void trackChangeEntry(ChangeSetItem changeSetItem, ChangeEntry changeEntry, boolean alreadyExecuted) {
        if (!(changeSetItem.isRunAlways() && alreadyExecuted || changeEntry.getState() == ChangeState.IGNORED && !this.trackIgnored)) {
            this.driver.getChangeEntryService().saveOrUpdate(changeEntry);
        }
    }

    protected void rollbackIfPresentAndTrackChangeEntry(String executionId, String executionHostname, Object changeLogInstance, ChangeSetItem changeSetItem, Exception changeSetException) throws InvocationTargetException, IllegalAccessException {
        block5: {
            block4: {
                ChangeType type;
                if (!changeSetItem.getRollbackMethod().isPresent()) break block4;
                logger.debug("rolling back changeSet[{}]", (Object)changeSetItem.getId());
                Optional<Object> rollbackExceptionOpt = Optional.empty();
                try {
                    this.executeChangeSetMethod(changeSetItem.getRollbackMethod().get(), changeLogInstance);
                    logger.debug("successfully rolled back changeSet[{}]", (Object)changeSetItem.getId());
                    type = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
                }
                catch (Exception ex2) {
                    try {
                        logger.debug("failure when rolling back changeSet[{}]:\n{}", (Object)changeSetItem.getId(), (Object)ex2.getMessage());
                        rollbackExceptionOpt = Optional.of(ex2);
                        throw ex2;
                    }
                    catch (Throwable throwable) {
                        ChangeType type2 = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
                        ChangeState state = rollbackExceptionOpt.map(ex -> ChangeState.ROLLBACK_FAILED).orElse(ChangeState.ROLLED_BACK);
                        ChangeEntry changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, state, type2, changeSetException, rollbackExceptionOpt.orElse(null));
                        this.logChangeEntry(changeEntry, changeSetItem, false);
                        this.trackChangeEntry(changeSetItem, changeEntry, false);
                        throw throwable;
                    }
                }
                ChangeState state = rollbackExceptionOpt.map(ex -> ChangeState.ROLLBACK_FAILED).orElse(ChangeState.ROLLED_BACK);
                ChangeEntry changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, state, type, changeSetException, rollbackExceptionOpt.orElse(null));
                this.logChangeEntry(changeEntry, changeSetItem, false);
                this.trackChangeEntry(changeSetItem, changeEntry, false);
                break block5;
            }
            logger.warn("ChangeSet[{}] does not provide rollback method", (Object)changeSetItem.getId());
        }
    }

    private void logChangeEntry(ChangeEntry changeEntry, ChangeSetItem changeSetItem, boolean alreadyExecuted) {
        switch (changeEntry.getState()) {
            case EXECUTED: {
                logger.info("{}APPLIED - {}", (Object)(alreadyExecuted ? "RE-" : ""), (Object)changeEntry.toPrettyString());
                break;
            }
            case IGNORED: {
                logger.info("PASSED OVER - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case FAILED: {
                logger.info("FAILED OVER - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case ROLLED_BACK: {
                logger.info("ROLLED BACK - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case ROLLBACK_FAILED: {
                logger.info("ROLL BACK FAILED- {}", (Object)changeSetItem.toPrettyString());
            }
        }
    }

    protected ChangeEntry buildChangeEntry(String executionId, String executionHostname, ChangeSetItem changeSetItem, long executionTimeMillis, ChangeState state, ChangeType type) {
        return this.buildChangeEntry(executionId, executionHostname, changeSetItem, executionTimeMillis, state, type, null, null);
    }

    protected ChangeEntry buildChangeEntry(String executionId, String executionHostname, ChangeSetItem changeSetItem, long executionTimeMillis, ChangeState state, ChangeType type, Exception executionException, Exception rollbackException) {
        if (executionException == null && rollbackException == null) {
            return ChangeEntry.instance((String)executionId, (String)(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)changeSetItem.getAuthor()) ? changeSetItem.getAuthor() : this.defaultAuthor), (ChangeState)state, (ChangeType)type, (String)changeSetItem.getId(), (String)changeSetItem.getMethod().getDeclaringClass().getName(), (String)changeSetItem.getMethod().getName(), (long)executionTimeMillis, (String)executionHostname, this.metadata);
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("execution-error", StringUtils.getStackTrace((Throwable)executionException));
        if (rollbackException != null) {
            errorMap.put("rollback-error", StringUtils.getStackTrace((Throwable)rollbackException));
        }
        return ChangeEntry.failedInstance((String)executionId, (String)(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)changeSetItem.getAuthor()) ? changeSetItem.getAuthor() : this.defaultAuthor), (ChangeState)state, (ChangeType)type, (String)changeSetItem.getId(), (String)changeSetItem.getMethod().getDeclaringClass().getName(), (String)changeSetItem.getMethod().getName(), (long)executionTimeMillis, (String)executionHostname, this.metadata, (String)new Gson().toJson(errorMap));
    }

    protected long executeChangeSetMethod(Method changeSetMethod, Object changeLogInstance) throws IllegalAccessException, InvocationTargetException {
        long startingTime = System.currentTimeMillis();
        this.changeLogRuntime.runChangeSet(changeLogInstance, changeSetMethod);
        return System.currentTimeMillis() - startingTime;
    }

    protected void processExceptionOnChangeSetExecution(Exception exception, ChangeSetItem changeSetItem, boolean throwException) {
        String exceptionMsg = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException().getMessage() : exception.getMessage();
        Method method = changeSetItem.getMethod();
        String finalMessage = String.format("Error in method[%s.%s] : %s", method.getDeclaringClass().getSimpleName(), method.getName(), exceptionMsg);
        this.updateRollbackChangeSet(changeSetItem, exception);
        if (throwException) {
            throw new MongockException(finalMessage, exception);
        }
        logger.warn(finalMessage, (Throwable)exception);
    }

    private void updateRollbackChangeSet(ChangeSetItem changeSetItem, Exception exception) {
        Iterator<Triple<Object, ChangeSetItem, Exception>> iterator = this.changeSetsToRollBack.iterator();
        boolean finished = false;
        while (iterator.hasNext() && !finished) {
            Triple<Object, ChangeSetItem, Exception> item = iterator.next();
            if (!changeSetItem.getId().equals(((ChangeSetItem)item.getSecond()).getId())) continue;
            item.setThird((Object)exception);
            finished = true;
        }
    }

    protected void initializationAndValidation() throws MongockException {
        this.executionInProgress = true;
        this.driver.initialize();
        this.driver.runValidation();
        this.changeLogRuntime.initialize(this.driver.getLockManager());
    }

    private void injectDependenciesFromDriver() {
        this.changeLogRuntime.updateDriverDependencies(this.driver.getDependencies());
    }

    protected void loadExecutedChangeEntries() {
        this.executedChangeEntries = this.driver.getChangeEntryService().getExecuted();
    }

    protected final boolean isDriverTransactional() {
        return this.globalTransactionEnabled == null ? this.driver.isTransactionable() : this.globalTransactionEnabled != false && this.driver.isTransactionable();
    }

    protected final boolean isStrategyPerChangeUnit() {
        return this.transactionStrategy == null || this.transactionStrategy == TransactionStrategy.CHANGE_UNIT;
    }

    protected final boolean isStrategyPerMigration() {
        return this.transactionStrategy == TransactionStrategy.EXECUTION;
    }

    protected void prepareForStageExecutionIfApply(boolean applyPreparation) {
        if (applyPreparation) {
            this.driver.prepareForExecutionBlock();
        }
    }

    protected void clearChangeSetsToRollbackIfApply(boolean applyPreparation) {
        if (applyPreparation) {
            this.changeSetsToRollBack.clear();
        }
    }
}

